jQuery( function( $ ) {
	const FOCUSABLE_SELECTORS = 'a[href], button, textarea, input[type="text"], input[type="radio"], input[type="checkbox"], select';

	$( '.siteorigin-lightbox-btn-open' ).on( 'click', function( e ) {
		e.preventDefault();

		const dialog = $( this )
			.parents( '.so-widget-so-premium-lightbox-builder' )
			.find( '.siteorigin-lightbox-builder' )
			.get( 0 );

		dialog.getAttribute( 'data-compatibility' ) ?
			dialog.show() :
			dialog.showModal();

		$( 'body' ).css( 'overflow', 'hidden' );

		let initialFocus = dialog;

		const focusable = $( dialog ).find( FOCUSABLE_SELECTORS );
		// If there are focusable elements, try changing the initial focus.
		if ( focusable.length > 0 ) {
			const firstFocusable = focusable.first();

			// Prevent the close button from being the initial focus.
			if ( firstFocusable.hasClass( 'siteorigin-lightbox-builder-close' ) ) {
				// The first focusable element is the close button. Check the next one.
				if ( focusable.length > 1 ) {
					initialFocus = focusable[1];
				}
			} else {
				initialFocus = firstFocusable[0];
			}
		}

		initialFocus.focus();

		$( window ).trigger( 'resize' );
	} );

	const lightboxBuilder = function() {
		const $$ = $( this );

		// Close the dialog when the user clicks the backdrop.
		$$.on( 'click', function( e ) {
			if ( e.target === $$.get( 0 ) ) {
				$$.get( 0 ).close();
			}
		} );

		$( '.siteorigin-lightbox-builder-close' ).on( 'click', function( e ) {
			$$.get( 0 ).close();
		} );

		$$.on( 'close', function() {
			$( 'body' ).css( 'overflow', '' );
		} );

		const focusable = $$.find( FOCUSABLE_SELECTORS );
		if ( focusable.length === 0 ) {
			return;
		}

		const firstEl = focusable.first()[0];
		const lastEl = focusable.last()[0];

		$$.on( 'keydown', function( e ) {
			// Only process Tab and Escape keys.
			if ( e.key === 'Escape' ) {
				e.preventDefault();
				this.close();
				return;
			}

			if ( e.key === 'Tab' ) {
				if ( e.shiftKey && document.activeElement === firstEl ) {
					e.preventDefault();
					lastEl.focus();
				} else if ( !e.shiftKey && document.activeElement === lastEl ) {
					e.preventDefault();
					firstEl.focus();
				}
			}
		} );
	};

	$( '.siteorigin-lightbox-builder' ).each( lightboxBuilder );
} );
