<?php
/*
Plugin Name: Lightbox Builder
Description: Create custom lightboxes with personalized design and content. Engage your users with dynamic, on-page overlays built with Page Builder.
Version: 1.0.0
Author: SiteOrigin
Author URI: https://siteorigin.com
License: GPL3
License URI: https://www.gnu.org/licenses/gpl-3.0.txt
Documentation: https://siteorigin.com/premium-documentation/plugin-addons/lightbox-builder/
Tags: Widgets Bundle
Video:
Requires: siteorigin-panels, so-widgets-bundle
*/

class SiteOrigin_Premium_Plugin_Lightbox_Builder {
	public function __construct() {
		if (
			! class_exists( 'SiteOrigin_Panels' ) &&
			! class_exists( 'SiteOrigin_Widgets_Bundle' )
		) {
			return;
		}

		add_filter( 'siteorigin_widgets_widget_folders', array( $this, 'add_widget' ) );
		add_action( 'init', array( $this, 'init_addon' ) );
		add_action( 'siteorigin_premium_addon_enabled-plugin/lightbox-builder', array( $this, 'widget_setup' ) );
	}

	public static function single() {
		static $single;

		return empty( $single ) ? $single = new self() : $single;
	}

	public function init_addon() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}

	public function add_widget( $folders ) {
		$folders[] = plugin_dir_path( __FILE__ ) . 'widgets/';

		return $folders;
	}

	public function widget_setup() {
		SiteOrigin_Widgets_Bundle::single()->activate_widget( 'lightbox-builder' );
	}

	public function enqueue_scripts() {
		wp_register_style(
			'so-premium-lightbox',
			plugin_dir_url( __FILE__ ) . 'js/lightbox' . SITEORIGIN_PREMIUM_JS_SUFFIX . '.css',
			array(),
			SITEORIGIN_PREMIUM_VERSION
		);

		wp_enqueue_script(
			'siteorigin-premium-lightbox-builder',
			plugin_dir_url( __FILE__ ) . 'js/lightbox' . SITEORIGIN_PREMIUM_JS_SUFFIX . '.js',
			array( 'jquery' ),
			SITEORIGIN_PREMIUM_VERSION,
			true
		);
	}
}
