<?php

/**
 * Created by PhpStorm.
 * User: steve
 * Date: 4/17/2018
 * Time: 10:09 PM
 */

if ( ! class_exists( "FooGallery_Pro_Video_oEmbed" ) ) {

	require_once dirname( __FILE__ ) . '/class-foogallery-pro-video-base.php';

	class FooGallery_Pro_Video_oEmbed extends FooGallery_Pro_Video_Base {

		/**
		 * Takes a URL and attempts to return a result generated from its oEmbed data.
		 *
		 * @param string $url The url to fetch.
		 *
		 * @return array(
		 *  "mode" => "embed",
		 *    "videos" => array(
		 *        array(
		 *            "provider" => string,
		 *            "id" => string,
		 *            "url" => string,
		 *            "thumbnail" => string,
		 *            "title" => string,
		 *            "description" => string,
		 *            "html" => string
		 *        )
		 *    )
		 * )
		 * @return array(
		 *    "mode" => "error",
		 *    "title" => string,
		 *    "message" => string
		 * )
		 */
		function fetch( $url ) {
			// check if the url is not empty and is not false
			if ( empty( $url ) || $url === false ) {
				return $this->error_response( "Invalid url supplied." );
			}

			$data = foogallery_oembed_get_data( $url );
			if ( $data === false ) {
				return $this->error_response( "Unable to retrieve any data from the supplied URL." );
			}
			if ( strtolower( $data->type ) !== "video" ) {
				return $this->error_response( "The data returned for the supplied URL was not a video." );
			}

			$provider = sanitize_title($data->provider_name, "oembed");

			$video = array(
				"provider" => $provider,
				"id" => $this->get_id($provider, $url),
				"url" => $url,
				"thumbnail" => $data->thumbnail_url,
				"title" => $data->title,
				"description" => !empty($data->description) ? $data->description : ""
			);

			if (empty($data->thumbnail_url) || empty($data->title)) {
				$video["mode"] = "oembed";
				return $video;
			}
			return array(
				"mode" => "embed",
				"videos" => array($video)
			);
		}

		/**
		 * Gets a unique ID for the supplied provider and url.
		 *
		 * @param string $provider The provider for the current URL.
		 * @param string $url      The URL to the oEmbed video.
		 *
		 * @return string
		 */
		private function get_id( $provider, $url ) {
			switch ( $provider ) {
				default:
					// this is setup so in the future we can handle different providers accordingly
					// but by default a ID is simply generated by hashing the url. This works fine as
					// the ID for oEmbed videos is just used to generate the uploaded filename and if
					// there is a duplicate WordPress will auto-append a count to the name in any case.
					return hash( 'crc32', $url, false );
			}
		}
	}
}