<?php

return array(
    // 1) SUNRISE
    array(
        'key' => 'video-sunrise',
        'url' => 'https://assets.fooplugins.com/pixabay/video/thumbs/sunrise.png',
        'video' => 'https://assets.fooplugins.com/pixabay/video/sunrise.mp4',
        'title' => 'Winter Sunrise Over Snowy Landscape',
        'caption' => 'Sunrise illuminating snow-covered countryside',
        'description' => 'A soft winter sunrise over frosty fields and rooftops, casting warm orange and pink hues across a frozen landscape. <a href="https://pixabay.com/users/thedog777-1625863/" target="_blank">Image Credit</a>',
        'alt' => 'Snowy winter morning with colorful sunrise sky',
        'tags' => array( 'Winter', 'Snow', 'Sunrise', 'Cold', 'Morning', 'Frost', 'Sky', 'Peaceful', 'Nature', 'Season' ),
        'categories' => array( 'Winter', 'Sunrise', 'Landscapes' ),
        'credit' => 'Video by Kevin Krämer from Pixabay'
    ),
    
    // 2) FIRE
	array(
		'key' => 'video-fire',
		'url' => 'https://assets.fooplugins.com/pixabay/video/thumbs/fire.png',
		'video' => 'https://assets.fooplugins.com/pixabay/video/fire.mp4',
		'title' => 'Cozy Fireplace',
		'caption' => 'Crackling fire burning warmly in a fireplace',
		'description' => 'A close-up view of glowing logs and flickering flames inside a cozy fireplace, creating a warm and comforting atmosphere. <a href="https://pixabay.com/users/mountaindweller-16471232/" target="_blank">Image Credit</a>',
		'alt' => 'Crackling fireplace with glowing logs and bright orange flames',
		'tags' => array( 'Fire', 'Warmth', 'Comfort', 'Relaxing', 'Flames', 'Cozy', 'Heat', 'Indoor', 'Glow', 'Autumn' ),
		'categories' => array( 'Fire', 'Cozy', 'Indoor' ),
		'credit' => 'Video by MountainDweller from Pixabay'
	),

	// 3) FOREST
	array(
		'key' => 'video-forest',
		'url' => 'https://assets.fooplugins.com/pixabay/video/thumbs/forest.png',
		'video' => 'https://assets.fooplugins.com/pixabay/video/forest.mp4',
		'title' => 'Sunlight Through Forest Stream',
		'caption' => 'Golden rays of sunlight streaming through forest trees',
		'description' => 'Morning light filtering through tall forest trees, illuminating a gentle flowing stream surrounded by lush greenery and mist. <a href="https://pixabay.com/users/missdeena-18652712/" target="_blank">Image Credit</a>',
		'alt' => 'Sunlight shining through forest onto flowing stream',
		'tags' => array( 'Forest', 'Stream', 'Nature', 'Sunlight', 'Green', 'Peaceful', 'Trees', 'Mist', 'Morning', 'Relaxation' ),
		'categories' => array( 'Forest', 'Water', 'Nature' ),
		'credit' => 'Video by Miss Deena from Pixabay'
	),

	// 4) MOUNTAIN LAKE
	array(
		'key' => 'video-mountain',
		'url' => 'https://assets.fooplugins.com/pixabay/video/thumbs/mountain.png',
		'video' => 'https://assets.fooplugins.com/pixabay/video/mountain.mp4',
		'title' => 'Mountain Lake Reflection',
		'caption' => 'Snow-capped peaks reflected in turquoise lake',
		'description' => 'Majestic snow-covered mountains mirrored in the still, turquoise waters of an alpine lake surrounded by pine forests. <a href="https://pixabay.com/users/rainmeditatehub-51172146/" target="_blank">Image Credit</a>',
		'alt' => 'Turquoise mountain lake reflecting snow-capped peaks',
		'tags' => array( 'Mountains', 'Lake', 'Reflection', 'Turquoise', 'Nature', 'Scenic', 'Water', 'Travel', 'Landscape', 'Snow' ),
		'categories' => array( 'Mountains', 'Water', 'Landscapes' ),
		'credit' => 'Video by Rain MeditateHub from Pixabay'
	),

	// 5) OPEN ROAD / RUNWAY
	array(
		'key' => 'video-road',
		'url' => 'https://assets.fooplugins.com/pixabay/video/thumbs/road.png',
		'video' => 'https://assets.fooplugins.com/pixabay/video/road.mp4',
		'title' => 'Open Road in the Mountains',
		'caption' => 'Lonely road stretching through mountain valley',
		'description' => 'A long, empty asphalt road leading through a cold mountain valley, symbolizing adventure, freedom, and exploration. <a href="https://pixabay.com/users/gylfi-28844009/" target="_blank">Image Credit</a>',
		'alt' => 'Long straight mountain road disappearing into the distance',
		'tags' => array( 'Road', 'Mountains', 'Travel', 'Adventure', 'Journey', 'Freedom', 'Valley', 'Drive', 'Landscape', 'Wilderness' ),
		'categories' => array( 'Travel', 'Mountains', 'Roads' ),
		'credit' => 'Video by Gylfi Gylfason from Pixabay'
	),

	// 6) LAVENDER
	array(
		'key' => 'video-lavender',
		'url' => 'https://assets.fooplugins.com/pixabay/video/thumbs/lavender.png',
		'video' => 'https://assets.fooplugins.com/pixabay/video/lavender.mp4',
		'title' => 'Lavender Field at Sunset',
		'caption' => 'Lavender flowers swaying in a sunset breeze',
		'description' => 'Rows of blooming lavender plants under a warm sunset sky, with pink petals floating through the air creating a romantic, serene scene. <a href="https://pixabay.com/users/mohamed_hassan-5229782/" target="_blank">Image Credit</a>',
		'alt' => 'Lavender field with pink petals and sunset light',
		'tags' => array( 'Lavender', 'Flowers', 'Sunset', 'Purple', 'Field', 'Nature', 'Romantic', 'Bloom', 'Fragrance', 'Peaceful' ),
		'categories' => array( 'Flowers', 'Fields', 'Nature' ),
		'credit' => 'Video by Mohamed Hassan from Pixabay'
	),

	// 7) OCEAN
	array(
		'key' => 'video-ocean',
		'url' => 'https://assets.fooplugins.com/pixabay/video/thumbs/ocean.png',
		'video' => 'https://assets.fooplugins.com/pixabay/video/ocean.mp4',
		'title' => 'Turquoise Ocean Waves',
		'caption' => 'Gentle turquoise waves rolling across the sea',
		'description' => 'Calm, pastel-blue waves rolling softly over the ocean surface, evoking a sense of peace and infinite openness. <a href="https://pixabay.com/users/missdeena-18652712/" target="_blank">Image Credit</a>',
		'alt' => 'Soft turquoise sea waves viewed from above',
		'tags' => array( 'Ocean', 'Waves', 'Sea', 'Water', 'Blue', 'Calm', 'Nature', 'Turquoise', 'Beach', 'Relaxing' ),
		'categories' => array( 'Water', 'Ocean', 'Nature' ),
		'credit' => 'Video by Miss Deena from Pixabay'
	),

	// 8) TURTLE
	array(
		'key' => 'video-turtle',
		'url' => 'https://assets.fooplugins.com/pixabay/video/thumbs/turtle.png',
		'video' => 'https://assets.fooplugins.com/pixabay/video/turtle.mp4',
		'title' => 'Sea Turtle Underwater',
		'caption' => 'Graceful turtle swimming in clear blue ocean',
		'description' => 'An underwater view of a sea turtle gliding effortlessly above coral and sand in crystal-clear blue tropical water. <a href="https://pixabay.com/users/jancickal-3757113/" target="_blank">Image Credit</a>',
		'alt' => 'Sea turtle swimming underwater over coral reef',
		'tags' => array( 'Turtle', 'Ocean', 'Underwater', 'Marine', 'Sea', 'Wildlife', 'Blue', 'Water', 'Nature', 'Diving' ),
		'categories' => array( 'Ocean', 'Wildlife', 'Nature' ),
		'credit' => 'Video by Lukáš Jančička from Pixabay'
	)
);
