<?php
if ( empty( $content ) ) {
	return;
}

// Dialog elements render on the Top Layer. This can cause issues with third-party
// libraries like Chosen. Compatibility mode disables usage of the Top Layer.
$compatibility_mode = apply_filters(
	'siteorigin_premium_lightbox_builder_compatibility_mode',
	false
);
?>
<dialog
	id="<?php echo esc_attr( $dialog_id ); ?>"
	class="siteorigin-lightbox-builder"
	<?php if ( ! empty( $title ) ) { ?>
		aria-labelledby="<?php echo esc_attr( $dialog_id ); ?>-title"
	<?php
	}

	if ( $compatibility_mode ) {
		?>
		data-compatibility="true"
	<?php } ?>
>

	<?php if ( $compatibility_mode ) { ?>
		<div class="siteorigin-lightbox-builder-content">
	<?php } ?>

	<?php if ( ! empty( $close_icon ) ) { ?>
		<button
			type="button"
			class="siteorigin-lightbox-builder-close siteorigin-lightbox-builder-close-<?php echo esc_attr( $close_icon_position ); ?>"
		>
			<span class="so-sr-only">
				<?php esc_html_e( 'Close lightbox', 'siteorigin-premium' ); ?>
			</span>
			<?php echo wp_kses_post( $close_icon ); ?>
		</button>
	<?php } ?>

	<?php if ( ! empty( $title ) ) { ?>
		<<?php echo esc_html( $title_tag ); ?>
			id="<?php echo esc_attr( $dialog_id ); ?>-title"
			class="siteorigin-lightbox-builder-title"
		>
			<?php echo wp_kses_post( $title ); ?>
		</<?php echo esc_html( $title_tag ); ?>>
	<?php } ?>

	<?php echo $content; ?>

	<?php if ( $compatibility_mode ) { ?>
		</div>
	<?php } ?>
</dialog>
<?php echo wp_kses_post( $button_open ); ?>
